package fr.asip.cps3.exemple.controleurs;

import iaik.pkcs.pkcs11.wrapper.Functions;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

import javax.swing.JMenuItem;

import org.apache.log4j.Logger;

import fr.asip.cps3.exemple.modele.Application;
import fr.asip.cps3.exemple.modele.MenuApplication;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionControleur;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionObjet;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.objets.Algo;
import fr.asip.cps3.exemple.modele.objets.Cle;
import fr.asip.cps3.exemple.modele.objets.Objet;
import fr.asip.cps3.exemple.modele.objets.Session;
import fr.asip.cps3.exemple.modele.objets.Slot;
import fr.asip.cps3.exemple.modele.objets.Token;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.general.InfoLibrairie;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.general.InitialiserLibrairie;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.general.TerminerLibrairie;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.generationaleatoire.GenerationNormale;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.objets.AfficheAtttributObjet;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.objets.CopierObjet;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.objets.SupprimerObjet;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.objets.TailleObjet;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.sessions.Deconnecter;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.sessions.FermerSession;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.sessions.FermerToutesLesSessions;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.sessions.InfoSession;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.sessions.OuvrirSession;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.slotscartes.AttenteEvenementSlot;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.slotscartes.InfoAlgo;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.slotscartes.InfoSlot;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.slotscartes.InfoToken;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.slotscartes.ListerAlgo;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.slotscartes.ListerSlots;
import fr.asip.cps3.exemple.modele.traitements.specifiques.AssistantAuthentification;
import fr.asip.cps3.exemple.modele.traitements.specifiques.AuthentificationApresRetraitCarte;
import fr.asip.cps3.exemple.modele.traitements.specifiques.AuthentificationApresRetraitLecteur;
import fr.asip.cps3.exemple.modele.traitements.specifiques.EtatConnexionCarte;
import fr.asip.cps3.exemple.modele.traitements.specifiques.EtatSaisieCodePorteur;
import fr.asip.cps3.exemple.modele.traitements.specifiques.LectureObjetDonneesApplicatives;
import fr.asip.cps3.exemple.modele.traitements.specifiques.ModificationObjetDonneesApplicatives;
import fr.asip.cps3.exemple.modele.traitements.specifiques.RecyclageCodePorteur;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import fr.asip.cps3.exemple.vues.ecrans.EcranUtil;
import fr.asip.cps3.exemple.vues.menus.ItemMenu;
import fr.asip.cps3.exemple.vues.menus.ItemMenuAlgo;
import fr.asip.cps3.exemple.vues.menus.ItemMenuCle;
import fr.asip.cps3.exemple.vues.menus.ItemMenuObjet;
import fr.asip.cps3.exemple.vues.menus.ItemMenuSession;
import fr.asip.cps3.exemple.vues.menus.ItemMenuSlot;
import fr.asip.cps3.exemple.vues.menus.ItemMenuToken;
import fr.asip.cps3.exemple.vues.menus.Menu;
import fr.asip.cps3.exemple.vues.menus.MenuAlgo;
import fr.asip.cps3.exemple.vues.menus.MenuToken;

/**
 * Classe d'intraction entre les items de menus et le modle
 *
 */
public class MenuControleur {

	/**
	 * Le loggeur
	 */
	 private static Logger log = Logger.getLogger(MenuControleur.class);	
	 
	/**
	 * Excute l'opration associe  l'item cliqu
	 * @param application
	 * @param item Item cliqu
	 */
	public static void executeOperation(Application application,ItemMenu item) {

		if(application != null && item != null && item.getId() != null) {

			try {			
			
				//###########//
				//# GENERAL #//
				//###########//
				
				if(item.getId().startsWith(MenuApplication.P11_GENERAL))
					executeOperationP11General(application, item);
				
				//##################//
				//# SLOTS & CARTES #//
				//##################//
	
				else if(item.getId().startsWith(MenuApplication.P11_SLOTSCARTES))
					executeOperationP11SlotEtCartes(application, item);
				
				//############//
				//# SESSIONS #//
				//############//
				
				else if(item.getId().startsWith(MenuApplication.P11_SESSIONS))
					executeOperationP11Sessions(application, item);
	
				//##########//
				//# OBJETS #//
				//##########//
				
				else if(item.getId().startsWith(MenuApplication.P11_OBJETS))
					executeOperationP11Objets(application, item);
				
				//##############//
				//# EMPREINTES #//
				//##############//
				
				else if(item.getId().startsWith(MenuApplication.P11_EMPREINTES))
					executeOperationP11Empreintes(application, item);
	
				//##############//
				//# SIGNATURES #//
				//##############//
				
				else if(item.getId().startsWith(MenuApplication.P11_SIGNATURES))
					executeOperationP11Signatures(application, item);
				
				//##########################//
				//# VERIFICATION SIGNATURE #//
				//##########################//
				
				else if(item.getId().startsWith(MenuApplication.P11_VERIFICATIONS))
					executeOperationP11Verification(application, item);
				
				//########################//
				//# GENERATION ALEATOIRE #//
				//########################//
				
				else if(item.getId().startsWith(MenuApplication.P11_GENERATION))
					executeOperationP11Generation(application, item);
				
				//############//
				//# OPTIONS #//
				//############//
				
				else if(item.getId().startsWith(MenuApplication.SESSIONS))
					executeChangementSession(application, item);

				//########################//
				//# ETAT CONNEXION CARTE #//
				//########################//				
				
				else if(item.getId().equalsIgnoreCase(MenuApplication.TRAITEMENTSSPECIFIQUES_AUTHENTIFICATION_ETATCONNEXION))		
					executeTraitementSpecifiqueEtatConnexionCarte(application, item);			

				//##############################//
				//# ASSISTANT AUTHENTIFICATION #//
				//##############################//
				else if(item.getId().equalsIgnoreCase(MenuApplication.TRAITEMENTSSPECIFIQUES_AUTHENTIFICATION_ASSISTAUTHENT))		
					executeTraitementSpecifiqueAssistantAuthentification(application, item);
				
				//############################//
				//# ETAT SAISIE CODE PORTEUR #//
				//############################//
				else if(item.getId().equalsIgnoreCase(MenuApplication.TRAITEMENTSSPECIFIQUES_PIN_ETATSAISIE))		
					executeTraitementSpecifiqueEtatSaisieCodePorteur(application, item);		
				
				//#############################//
				//# RECYCLAGE DU CODE PORTEUR #//
				//#############################//
				else if(item.getId().equalsIgnoreCase(MenuApplication.TRAITEMENTSSPECIFIQUES_PIN_RECYCLAGE))		
					executeTraitementSpecifiqueRecyclageCodePorteur(application);
				
				//########################################//
				//# AUTHENTIFICATION APRES RETRAIT CARTE #//
				//########################################//
				else if(item.getId().equalsIgnoreCase(MenuApplication.TRAITEMENTSSPECIFIQUES_AUTHENTIFICATION_RETRAITCARTE))		
					executeTraitementSpecifiqueAuthentificationApresRetraitCarte(application);
				
				//##########################################//
				//# AUTHENTIFICATION APRES RETRAIT LECTEUR #//
				//##########################################//
				else if(item.getId().equalsIgnoreCase(MenuApplication.TRAITEMENTSSPECIFIQUES_AUTHENTIFICATION_RETRAITLECTEUR))		
					executeTraitementSpecifiqueAuthentificationApresRetraitLecteur(application);
				
				//##########################################//
				//# LECTURE D'OBJET DE DONNEES APPLICATIVES #//
				//##########################################//
				else if(item.getId().equalsIgnoreCase(MenuApplication.TRAITEMENTSSPECIFIQUES_JETONS_LECTURE))		
					executeTraitementSpecifiqueLectureObjetDonneesApplicatives(application);

				//################################################//
				//# MODIFICATION D'OBJET DE DONNEES APPLICATIVES #//
				//################################################//
				else if(item.getId().equalsIgnoreCase(MenuApplication.TRAITEMENTSSPECIFIQUES_JETONS_MODIFICIATION))		
					executeTraitementSpecifiqueModificationObjetDonneesApplicatives(application);
				
			} catch (ExceptionProgrammeExemple e) {
				
				// Demande d'affichage de l'exception
				application.notifieException(e);
				
			} catch (Throwable t) {
				
				log.error("Une erreur inattendue est survenue : "+ExceptionProgrammeExemple.getStacktrace(t));
				// Demande d'affichage de l'exception
				application.notifieException(new ExceptionControleur(ExceptionProgrammeExemple.TYPE_CONTROLEUR_MENU,"Une erreur inattendue est survenue"));
				
			}

		} else {
			
			log.error("L'application et/ou l'item clique est nul");
			
			// Demande d'affichage de l'exception (si possible)
			if(application != null)
				application.notifieException(new ExceptionControleur(ExceptionProgrammeExemple.TYPE_CONTROLEUR_MENU,"Une erreur inattendue est survenue"));	
			
		}
		
	}

	/**
	 * Execute l'opration PKCS#11 concerne par l'item cliqu (opration lie de type Gnral)
	 * @param application L'application
	 * @param item L'item cliqu
	 * @throws ExceptionProgrammeExemple 
	 */
	private static void executeOperationP11General(Application application, ItemMenu item) throws ExceptionProgrammeExemple {
		
		Resultat resultat = null;
		
		// > INITIALISER LA LIBRAIRIE
		if(MenuApplication.P11_GENERAL_INITLIB.equalsIgnoreCase(item.getId())) {
			resultat = InitialiserLibrairie.traitementP11(application.getLibrairieP11());
			// Dclenchement de l'affichage
			if(resultat != null)
				application.declencheAffichageResultat(resultat);
			// MAJ Menus
			if(resultat != null && (resultat.getCodeRetourStr() != null && (resultat.getCodeRetourStr().startsWith("CKR_OK") || resultat.getCodeRetourStr().startsWith("CKR_CRYPTOKI_ALREADY_INITIALIZED")))) {
				refresh(application, item.getId());
				application.declencheMAJMenus();
			}
		}
		
		// > TERMINER LA LIBRAIRIE
		else if(MenuApplication.P11_GENERAL_TERMINLIB.equalsIgnoreCase(item.getId())) {
			resultat = TerminerLibrairie.traitementP11(application.getLibrairieP11());
			// Dclenchement de l'affichage
			if(resultat != null)
				application.declencheAffichageResultat(resultat);
			// MAJ Menus
			if(resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_OK")) {
				application.supprimeTousLesElementsEnCours();
				refresh(application, item.getId());
				application.declencheMAJMenus();
			}
		}
		
		// > OBTENIR DES INFORMATIONS SUR LA LIBRAIRIE
		else if(MenuApplication.P11_GENERAL_INFOLIB.equalsIgnoreCase(item.getId())) {
			resultat = InfoLibrairie.traitementP11(application.getLibrairieP11());
			// Dclenchement de l'affichage
			if(resultat != null)
				application.declencheAffichageResultat(resultat);
		}

	}
	
	/**
	 * Execute l'opration PKCS#11 concerne par l'item cliqu (opration lie de type Slots & Cartes)
	 * @param application L'application
	 * @param item L'item cliqu
	 * @throws ExceptionProgrammeExemple
	 * @throws PKCS11Exception 
	 */
	private static void executeOperationP11SlotEtCartes(Application application, ItemMenu item) throws ExceptionProgrammeExemple, PKCS11Exception {

		Resultat resultat = null;
		
		// > LISTER LES SLOTS AVEC CARTES
		if(MenuApplication.P11_SLOTSCARTES_LISTER_AVECCARTES.equalsIgnoreCase(item.getId())) {
			resultat = ListerSlots.traitementP11(application.getLibrairieP11(),true);
			// Dclenchement de l'affichage
			if(resultat != null)
				application.declencheAffichageResultat(resultat);
			// MAJ Menus
			if(resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_OK") && resultat.getObjets() != null && resultat.getObjets().size() > 0) {
				//application.declencheAffichageResultat(resultat);
				application.supprimeTousLesElementsEnCours();
				application.ajouteLesSlots(resultat.getObjets(), true);
				refresh(application, item.getId());
				application.declencheMAJMenus();
			}				
		}
		
		// > LISTER TOUS LES SLOTS
		else if(MenuApplication.P11_SLOTSCARTES_LISTER_TOUS.equalsIgnoreCase(item.getId())) {
			resultat = ListerSlots.traitementP11(application.getLibrairieP11(),false);
			// Dclenchement de l'affichage
			if(resultat != null)
				application.declencheAffichageResultat(resultat);
			// MAJ Menus
			if(resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_OK") && resultat.getObjets() != null && resultat.getObjets().size() > 0) {
				application.supprimeTousLesElementsEnCours();
				application.ajouteLesSlots(resultat.getObjets(), false);
				refresh(application, item.getId());
				application.declencheMAJMenus();
			}
		}
		
		// > OBTENIR DES INFORMATIONS SUR LE SLOT
		else if(item.getId().startsWith(MenuApplication.P11_SLOTSCARTES_INFOSLOT)) {
			resultat = InfoSlot.traitementP11(application.getLibrairieP11(),((ItemMenuSlot)item).getSlot().getIdSlot());
			// Dclenchement de l'affichage
			if(resultat != null)
				application.declencheAffichageResultat(resultat);
			// MAJ Menus
			if(resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_OK")) {
				refresh(application, MenuApplication.P11_SLOTSCARTES_INFOSLOT);
				application.declencheMAJMenus();
			}
			
		}
		
		// > OBTENIR DES INFORMATIONS SUR LA CARTE
		else if(item.getId().startsWith(MenuApplication.P11_SLOTSCARTES_INFOCARTE)) {
			resultat = InfoToken.traitementP11(application.getLibrairieP11(),((ItemMenuToken)item).getToken().getIdSlotToken());
			// Dclenchement de l'affichage
			if(resultat != null)
				application.declencheAffichageResultat(resultat);
		}
		
		// > ATTENTE D'UN EVENEMENT SLOT EN MODE BLOQUE
		else if(MenuApplication.P11_SLOTSCARTES_ATTENTEEVNTSLOT_BLOQUE.equalsIgnoreCase(item.getId())) {
			resultat = AttenteEvenementSlot.traitementP11(application.getLibrairieP11(), true);
			// Dclenchement de l'affichage
			if(resultat != null)
				application.declencheAffichageResultat(resultat);
		}
		
		// > ATTENTE D'UN EVENEMENT SLOT EN MODE DEBLOQUE
		else if(MenuApplication.P11_SLOTSCARTES_ATTENTEEVNTSLOT_DEBLOQUE.equalsIgnoreCase(item.getId())) {
			resultat = AttenteEvenementSlot.traitementP11(application.getLibrairieP11(), false);
			// Dclenchement de l'affichage
			if(resultat != null)
				application.declencheAffichageResultat(resultat);
		}
		
		// > LISTER LES ALGORITHMES DE LA CARTE
		else if(item.getId().startsWith(MenuApplication.P11_SLOTSCARTES_LISTERALGOCARTE)) {
			resultat = ListerAlgo.traitementP11(application.getLibrairieP11(), ((ItemMenuToken)item).getToken().getIdSlotToken());
			// Dclenchement de l'affichage
			if(resultat != null)
				application.declencheAffichageResultat(resultat);
			// MAJ Menus
			if(resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_OK") && resultat.getObjets() != null && resultat.getObjets().size() > 0) {		
				// Mise  jour du menu
				application.supprimeTousLesAlgo(((ItemMenuToken)item).getToken().getNumeroSerie());
				application.ajouteLesAlgo(((ItemMenuToken)item).getToken(),resultat.getObjets());
				refresh(application, MenuApplication.P11_SLOTSCARTES_LISTERALGOCARTE);
				application.declencheMAJMenus();
			}
		}
		
		// > OBTENIR DES INFORMATIONS SUR L'ALGORITHME
		else if(item.getId().startsWith(MenuApplication.P11_SLOTSCARTES_INFOALGO)) {
			resultat = InfoAlgo.traitementP11(application.getLibrairieP11(), ((ItemMenuAlgo)item).getAlgo().getIdSlotToken(), ((ItemMenuAlgo)item).getAlgo().getIdAlgo());
			// Dclenchement de l'affichage
			if(resultat != null)
				application.declencheAffichageResultat(resultat);
		}

		// > INITIALISER LE CODE PORTEUR DE LA CARTE
//		else if(item.getId().startsWith(MenuApplication.P11_SLOTSCARTES_INITPIN))
		else if(item.getId().equalsIgnoreCase(MenuApplication.P11_SLOTSCARTES_INITPIN))
			application.declencheAffichageEcran(EcranUtil.TYPE_ECRAN_INIT_CODE_PORTEUR);
		
		// > MODIFIER LE CODE PORTEUR DE LA CARTE
//		else if(item.getId().startsWith(MenuApplication.P11_SLOTSCARTES_MODIFPIN))
		else if(item.getId().equalsIgnoreCase(MenuApplication.P11_SLOTSCARTES_MODIFPIN))
			application.declencheAffichageEcran(EcranUtil.TYPE_ECRAN_MODIF_CODE_PORTEUR);
		
	}
	

	/**
	 * Execute l'opration PKCS#11 concerne par l'item cliqu (opration lie de type Sessions)
	 * @param application L'application
	 * @param item L'item cliqu
	 * @throws ExceptionProgrammeExemple
	 */
	private static void executeOperationP11Sessions(Application application, ItemMenu item) throws ExceptionProgrammeExemple {
		
		Resultat resultat = null;
		
		// > OUVRIR UNE SESSION EN LECTURE/ECRITURE
		if(item.getId().startsWith(MenuApplication.P11_SESSIONS_OUVRIR_LECTECRIT)) {
			resultat = OuvrirSession.traitementP11(application.getLibrairieP11(), ((ItemMenuToken)item).getToken().getIdSlotToken(), true);
			// Dclenchement de l'affichage
			if(resultat != null)
				application.declencheAffichageResultat(resultat);
			// MAJ Menus
			if(resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_OK") && resultat.getObjets() != null && resultat.getObjets().size() > 0) {		
				application.ajouteLaSession(((ItemMenuToken)item).getToken(),(Long)resultat.getObjets().get(0));
				refresh(application, MenuApplication.P11_SESSIONS_OUVRIR_LECTECRIT);
				application.declencheMAJMenus();
			}
		}
		
		// > OUVRIR UNE SESSION EN LECTURE SEULE
		else if(item.getId().startsWith(MenuApplication.P11_SESSIONS_OUVRIR_LECTSEULE)) {
			resultat = OuvrirSession.traitementP11(application.getLibrairieP11(), ((ItemMenuToken)item).getToken().getIdSlotToken(), false);
			// Dclenchement de l'affichage
			if(resultat != null)
				application.declencheAffichageResultat(resultat);
			// MAJ Menus
			if(resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_OK") && resultat.getObjets() != null && resultat.getObjets().size() > 0) {		
				application.ajouteLaSession(((ItemMenuToken)item).getToken(),(Long)resultat.getObjets().get(0));
				refresh(application, MenuApplication.P11_SESSIONS_OUVRIR_LECTSEULE);
				application.declencheMAJMenus();
			}
		}
		
		// > OBTENIR DES INFORMATIONS SUR LA SESSION
		else if(item.getId().equalsIgnoreCase(MenuApplication.P11_SESSIONS_INFO)) {
			if(application.getSessionCourante() != null)
				resultat = InfoSession.traitementP11(application.getLibrairieP11(), application.getSessionCourante().getIdSession());
			else {
				log.error("Une erreur inattendue est survenue lors de la tentative d'execution de l'operation de recuperation d'information sur la session : Il n'y a pas de session en cours");
				application.notifieException(new ExceptionControleur(ExceptionProgrammeExemple.TYPE_CONTROLEUR_MENU,"Une erreur inattendue est survenue"));

			}
			// Dclenchement de l'affichage
			if(resultat != null)
				application.declencheAffichageResultat(resultat);
		}
	
		// > FERMER LA SESSION
		else if(item.getId().startsWith(MenuApplication.P11_SESSIONS_FERMER)) {
			resultat = FermerSession.traitementP11(application.getLibrairieP11(), ((ItemMenuSession)item).getSession().getIdSession());
			// Dclenchement de l'affichage
			if(resultat != null)
				application.declencheAffichageResultat(resultat);
			// MAJ Menus
			if(resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_OK")) {
				application.supprimeLaSession(((ItemMenuSession)item).getSession().getIdToken(),((ItemMenuSession)item).getSession());
				if(application.nbSessionsActives() == 0)
					application.setSessionCourante(null);
				refresh(application, MenuApplication.P11_SESSIONS_FERMER);
				application.declencheMAJMenus();
			}
		}
	
		// > FERMER TOUTES LES SESSIONS ACTIVES
		else if(item.getId().startsWith(MenuApplication.P11_SESSIONS_FERMER_TOUTES)) {
			resultat = FermerToutesLesSessions.traitementP11(application.getLibrairieP11(), ((ItemMenuToken)item).getToken().getIdSlotToken());
			// Dclenchement de l'affichage
			if(resultat != null)
				application.declencheAffichageResultat(resultat);
			// MAJ Menus
			if(resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_OK")) {
				application.supprimeToutesLesSessions(((ItemMenuToken)item).getToken());
				if(application.nbSessionsActives() == 0)
					application.setSessionCourante(null);
				refresh(application, MenuApplication.P11_SESSIONS_FERMER_TOUTES);
				application.declencheMAJMenus();
			}
		}			
	
		// > S'AUTHENTIFIER UTILISATEUR
		else if(item.getId().equalsIgnoreCase(MenuApplication.P11_SESSIONS_AUTHENT_UTILISATEUR))
			application.declencheAffichageEcran(EcranUtil.TYPE_ECRAN_AUTHENTIFICATION_UTILISATEUR);
		
		// > S'AUTHENTIFIER SO
		else if(item.getId().equalsIgnoreCase(MenuApplication.P11_SESSIONS_AUTHENT_SO))
			application.declencheAffichageEcran(EcranUtil.TYPE_ECRAN_AUTHENTIFICATION_SO);
		
		// > Se dsauthentifier
		else if(item.getId().equalsIgnoreCase(MenuApplication.P11_SESSIONS_DECONNECTE)) {
			if(application.getSessionCourante() != null) {
				resultat = Deconnecter.traitementP11(application.getLibrairieP11(), application.getSessionCourante().getIdSession());
				// Dclenchement de l'affichage
				if(resultat != null)
					application.declencheAffichageResultat(resultat);
				// MAJ Menus
				if(resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_OK")) {
					application.getSessionCourante().chargeInfo(application.getLibrairieP11());
					refresh(application, MenuApplication.P11_SESSIONS_DECONNECTE);
					application.declencheMAJMenus();
				}
			}
		}
		
	}	
	
	/**
	 * Execute l'opration PKCS#11 concerne par l'item cliqu (opration lie de type Objets)
	 * @param application L'application
	 * @param item L'item cliqu
	 * @throws ExceptionProgrammeExemple
	 */
	private static void executeOperationP11Objets(Application application, ItemMenu item) throws ExceptionProgrammeExemple {
	
		Resultat resultat = null;
		
		// > GESTION OBJETS
		if(item.getId().startsWith(MenuApplication.P11_OBJETS_GESTION)) {
				
			//  > CREATION
			if(item.getId().equalsIgnoreCase(MenuApplication.P11_OBJETS_GESTION_CREER_SURCARTE)) {
				application.declencheAffichageEcran(EcranUtil.TYPE_ECRAN_CREATION_OBJETS,null);
			}
			
			//  > SUPPRESSION
			else if(item.getId().startsWith(MenuApplication.P11_OBJETS_GESTION_SUPPR_SURCARTE)) {
				Objet objet = ((ItemMenuObjet)item).getObjet();
				if(objet != null && application.getSessionCourante() != null) {
					resultat = SupprimerObjet.traitementP11(application.getLibrairieP11(), application.getSessionCourante().getIdSession(), objet.getIdObjet(), objet.getLibelle());
					// Dclenchement de l'affichage
					if(resultat != null)
						application.declencheAffichageResultat(resultat);
					// MAJ Menus				
					// Pour mettre  jour la liste des objets on fait une recherche des objets de donnes applicatives
					if(resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_OK")) {
						TraitementsUtil.rechercheObjets(application, TraitementsUtil.TYPE_OBJET_DONNEES_APPLICATIVES, objet.getLibelle(), false);
					}		
					application.declencheMAJMenus();
					
				} else {
					log.error("Une erreur inattendue est survenue lors de la tentative d'execution de l'operation de suppression de l'objet : L'objet vaut null et/ou Il n'y a pas de session en cours");
					application.notifieException(new ExceptionControleur(ExceptionProgrammeExemple.TYPE_CONTROLEUR_MENU,"Une erreur inattendue est survenue"));
				}
			}

			//  > COPIE
			else if(item.getId().startsWith(MenuApplication.P11_OBJETS_GESTION_COPIER_SURCARTE)) {
				Objet objet = ((ItemMenuObjet)item).getObjet();
				if(objet != null && application.getSessionCourante() != null) {
					resultat = CopierObjet.traitementP11(application.getLibrairieP11(), application.getSessionCourante().getIdSession(), objet.getIdObjet(), objet.getLibelle());
					// Dclenchement de l'affichage
					if(resultat != null)
						application.declencheAffichageResultat(resultat);

					// Pour mettre  jour la liste des objets on fait une recherche des objets de donnes applicatives
					if(resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_OK")) {
						TraitementsUtil.rechercheObjets(application, TraitementsUtil.TYPE_OBJET_DONNEES_APPLICATIVES, null, false);
					}	
					application.declencheMAJMenus();
					
				} else {
					log.error("Une erreur inattendue est survenue lors de la tentative d'execution de l'operation de copie de l'objet : L'objet vaut null et/ou Il n'y a pas de session en cours");
					application.notifieException(new ExceptionControleur(ExceptionProgrammeExemple.TYPE_CONTROLEUR_MENU,"Une erreur inattendue est survenue"));
				}
			}

			//  > OBTENIR LA TAILLE
			else if(item.getId().startsWith(MenuApplication.P11_OBJETS_GESTION_TAILLE_SURCARTE)) {
				Objet objet = ((ItemMenuObjet)item).getObjet();
				if(objet != null && application.getSessionCourante() != null) {
					resultat = TailleObjet.traitementP11(application.getLibrairieP11(), application.getSessionCourante().getIdSession(), objet.getIdObjet(), objet.getLibelle());
					// Dclenchement de l'affichage
					if(resultat != null)
						application.declencheAffichageResultat(resultat);
					// MAJ Menus		
					application.declencheMAJMenus();
				} else {
					log.error("Une erreur inattendue est survenue lors de la tentative d'execution de l'operation d'obtention de la taille de l'objet : L'objet vaut null et/ou Il n'y a pas de session en cours");
					application.notifieException(new ExceptionControleur(ExceptionProgrammeExemple.TYPE_CONTROLEUR_MENU,"Une erreur inattendue est survenue"));
				}
			}
			
			//  > AFFICHER ATTRIBUT
			else if(item.getId().startsWith(MenuApplication.P11_OBJETS_GESTION_AFFICHEATTRIBUT_SURCARTE)) {
				Objet objet = ((ItemMenuObjet)item).getObjet();
				if(objet != null && application.getSessionCourante() != null) {
					resultat = AfficheAtttributObjet.traitementP11(application.getLibrairieP11(), application.getSessionCourante().getIdSession(), objet.getIdObjet(), objet.getLibelle());
					// Dclenchement de l'affichage
					if(resultat != null)
						application.declencheAffichageResultat(resultat);
					// MAJ Menus		
					application.declencheMAJMenus();
				} else {
					log.error("Une erreur inattendue est survenue lors de la tentative d'execution de l'operation d'obtention de la valeur d'un l'attribut de l'objet : L'objet vaut null et/ou Il n'y a pas de session en cours");
					application.notifieException(new ExceptionControleur(ExceptionProgrammeExemple.TYPE_CONTROLEUR_MENU,"Une erreur inattendue est survenue"));
				}
			}

			//  > MODIFIER ATTRIBUT
			else if(item.getId().startsWith(MenuApplication.P11_OBJETS_GESTION_MODIFATTRIBUT_SURCARTE)) {
				Objet objet = ((ItemMenuObjet)item).getObjet();
				if(objet != null && application.getSessionCourante() != null)  {
					application.declencheAffichageEcran(EcranUtil.TYPE_ECRAN_MODIFICATION_OBJETS,objet);
				} else {
					log.error("Une erreur inattendue est survenue lors de la tentative d'execution de l'operation de modification de la valeur d'un l'attribut de l'objet : L'objet vaut null et/ou Il n'y a pas de session en cours");
					application.notifieException(new ExceptionControleur(ExceptionProgrammeExemple.TYPE_CONTROLEUR_MENU,"Une erreur inattendue est survenue"));
				}
			}
				
		}
		
		// > RECHERCHE OBJETS
		else if(item.getId().startsWith(MenuApplication.P11_OBJETS_RECHERCHE)) {
			
			int type = 0;
			String filtre = null;
			
			//  > CERTIFICATS
			if(item.getId().equalsIgnoreCase(MenuApplication.P11_OBJETS_RECHERCHE_CERTIFICATS))
				type = TraitementsUtil.TYPE_OBJET_CERTIFICAT;
			
			//  > CLES PUBLIQUES
			else if(item.getId().equalsIgnoreCase(MenuApplication.P11_OBJETS_RECHERCHE_CLEPUBLIQUE))
				type = TraitementsUtil.TYPE_OBJET_CLE_PUBLIQUE;
			
			//  > CLES PRIVEES
			else if(item.getId().equalsIgnoreCase(MenuApplication.P11_OBJETS_RECHERCHE_CLEPRIVEE))
				type = TraitementsUtil.TYPE_OBJET_CLE_PRIVE;
			
			//  > OBJETS DE DONNEES APPLICATIVES
			if(item.getId().equalsIgnoreCase(MenuApplication.P11_OBJETS_RECHERCHE_OBJETS)) {
				type = TraitementsUtil.TYPE_OBJET_DONNEES_APPLICATIVES;
				
				application.declencheAffichageEcran(EcranUtil.TYPE_ECRAN_RECHERCHE_OBJETS, null);				
			
			}
			
			if(!item.getId().equalsIgnoreCase(MenuApplication.P11_OBJETS_RECHERCHE_OBJETS))
				resultat = TraitementsUtil.rechercheObjets(application, type, filtre, true);

			// Dclenchement de l'affichage
			if(resultat != null) {
				application.declencheAffichageResultat(resultat);			
			
				// MAJ Menus		
				application.declencheMAJMenus();
			}
			
		}
		
	}



	/**
	 * Dclenche l'affichage de l'cran de saisie permettant de raliser l'opration PKCS#11 concerne par l'item cliqu (opration lie de type Empreintes)
	 * @param application L'application
	 * @param item L'item cliqu
	 * @throws ExceptionProgrammeExemple 
	 */
	private static void executeOperationP11Empreintes(Application application, ItemMenu item) throws ExceptionProgrammeExemple {
		
		// > GENERER EMPREINTE MESSAGE COURT
		if(item.getId().startsWith(MenuApplication.P11_EMPREINTES_MESSAGE))
			application.declencheAffichageEcran(EcranUtil.TYPE_ECRAN_GENERATION_EMPREINTE_MESSAGE,((ItemMenuAlgo)item).getAlgo());
		
		// > GENERER EMPREINTE FICHIER
		else if(item.getId().startsWith(MenuApplication.P11_EMPREINTES_FICHIER))
			application.declencheAffichageEcran(EcranUtil.TYPE_ECRAN_GENERATION_EMPREINTE_FICHIER,((ItemMenuAlgo)item).getAlgo());
		
	}

	/**
	 * Dclenche l'affichage de l'cran de saisie permettant de raliser l'opration PKCS#11 concerne par l'item cliqu (opration lie de type Signatures)
	 * @param application L'application
	 * @param item L'item cliqu
	 * @throws ExceptionProgrammeExemple 
	 */
	private static void executeOperationP11Signatures(Application application, ItemMenu item) throws ExceptionProgrammeExemple {

		// Il faut transmettre la cl ainsi que l'algorithme
		Vector<Object> objets = new Vector<Object>();
		
		ItemMenuCle itemCle = (ItemMenuCle)item;			
		// recupration de l'algorithme et dclenchement de l'affichage
		MenuAlgo menuAlgo = (MenuAlgo) application.getMenu(itemCle.getIdParent());
		if(menuAlgo != null && menuAlgo.getAlgo() != null && itemCle != null && itemCle.getCle() != null) {
			objets.add(menuAlgo.getAlgo());
			objets.add(itemCle.getCle());
			
			// > SIGNATURE D'UN MESSAGE COURT
			if(item.getId().startsWith(MenuApplication.P11_SIGNATURES_MESSAGE))
				application.declencheAffichageEcran(EcranUtil.TYPE_ECRAN_GENERATION_SIGNATURE_MESSAGE,objets);
			
			// > SIGNATURE D'UN FICHIER
			else if(item.getId().startsWith(MenuApplication.P11_SIGNATURES_FICHIER))
				application.declencheAffichageEcran(EcranUtil.TYPE_ECRAN_GENERATION_SIGNATURE_FICHIER,objets);
			
		} else {
			log.error("Une erreur inattendue est survenue lors de la tentative d'affichage de l'ecran de saisie pour la signature : Le couple algo/cl est incomplet");
			application.notifieException(new ExceptionControleur(ExceptionProgrammeExemple.TYPE_CONTROLEUR_MENU,"Une erreur inattendue est survenue"));
		}

	}

	/**
	 * Dclenche l'affichage de l'cran de saisie permettant de raliser l'opration PKCS#11 concerne par l'item cliqu (opration lie de type Vrification de signature)
	 * @param application L'application
	 * @param item L'item cliqu
	 * @throws ExceptionProgrammeExemple 
	 */
	private static void executeOperationP11Verification(Application application, ItemMenu item) throws ExceptionProgrammeExemple {

		// Il faut transmettre la cl, l'algorithme
		Vector<Object> objets = new Vector<Object>();
		
		ItemMenuCle itemCle = (ItemMenuCle)item;			
		// recupration de l'algorithme et dclenchement de l'affichage
		MenuAlgo menuAlgo = (MenuAlgo) application.getMenu(itemCle.getIdParent());
		if(menuAlgo != null && menuAlgo.getAlgo() != null) {
			objets.add(menuAlgo.getAlgo());
			objets.add(itemCle.getCle());
			
			// > VERIFICATION DE SIGNATURE D'UN MESSAGE COURT
			if(item.getId().startsWith(MenuApplication.P11_VERIFICATIONS_MESSAGE)) {
				
				// Il faut transmettre le message sign et la signature du message
				if(application.getMessageSigne() != null && application.getSignatureMessage() != null) {
					
					objets.add(application.getMessageSigne());
					objets.add(application.getSignatureMessage());
					application.declencheAffichageEcran(EcranUtil.TYPE_ECRAN_VERIFICATION_SIGNATURE_MESSAGE,objets);
					
				} else {
					log.error("Une erreur inattendue est survenue lors de la tentative d'affichage de l'ecran de saisie pour la verification de signature du message : Le message signe/signature est incomplet");
					application.notifieException(new ExceptionControleur(ExceptionProgrammeExemple.TYPE_CONTROLEUR_MENU,"Une erreur inattendue est survenue"));
				}
			}
			
			// > SIGNATURE D'UN FICHIER
			else if(item.getId().startsWith(MenuApplication.P11_VERIFICATIONS_FICHIER)) {
				
				// Il faut transmettre le fichier sign et la signature du fichier
				if(application.getFichierSigne() != null && application.getSignatureFichier() != null) {
					
					objets.add(application.getFichierSigne());
					objets.add(application.getSignatureFichier());
					application.declencheAffichageEcran(EcranUtil.TYPE_ECRAN_VERIFICATION_SIGNATURE_FICHIER,objets);
					
				} else {
					log.error("Une erreur inattendue est survenue lors de la tentative d'affichage de l'ecran de saisie pour la verification de signature du fichier : Le fichier signe/signature est incomplet");
					application.notifieException(new ExceptionControleur(ExceptionProgrammeExemple.TYPE_CONTROLEUR_MENU,"Une erreur inattendue est survenue"));
				}				
				
			}
			
		} else {
			log.error("Une erreur inattendue est survenue lors de la tentative d'affichage de l'ecran de saisie pour la verification de signature : Le couple algo/cl est incomplet");
			application.notifieException(new ExceptionControleur(ExceptionProgrammeExemple.TYPE_CONTROLEUR_MENU,"Une erreur inattendue est survenue"));			
		}
		
	}
	
	
	/**
	 * Execute l'opration PKCS#11 concerne par l'item cliqu (opration lie de type Gnration de nombre pseudo-alatoire)
	 * @param application L'application
	 * @param item L'item cliqu
	 * @throws ExceptionProgrammeExemple 
	 */
	private static void executeOperationP11Generation(Application application, ItemMenu item) throws ExceptionProgrammeExemple {

		Resultat resultat = null;
			

		// > NORMALE
		if(item.getId().equalsIgnoreCase((MenuApplication.P11_GENERATION_NORMALE))) {
			if(application.getSessionCourante() != null)
				resultat = GenerationNormale.traitementP11(application.getLibrairieP11(), application.getSessionCourante().getIdSession());
			// Dclenchement de l'affichage
			if(resultat != null) {
				application.declencheAffichageResultat(resultat);
				
				// MAJ Menus		
				application.declencheMAJMenus();
			}
			else {
				log.error("Une erreur inattendue est survenue lors de la tentative d'execution de l'operation de generation normale de nombre pseudo aleatoire : Il n'y a pas de session en cours");
				application.notifieException(new ExceptionControleur(ExceptionProgrammeExemple.TYPE_CONTROLEUR_MENU,"Une erreur inattendue est survenue"));
			}
		}
	
		// > AVEC SEED
		else if(item.getId().equalsIgnoreCase((MenuApplication.P11_GENERATION_SEED))) {
			application.declencheAffichageEcran(EcranUtil.TYPE_ECRAN_GENERATION_AVEC_SEED);
		}
			
	}	

	
	/**
	 * Effectue le changement de session
	 * @param application L'application
	 * @param item L'item cliqu
	 */
	private static void executeChangementSession(Application application, ItemMenu item) {

		// > CHANGEMENT DE SESSION
		if(application.getSessionCourante() != null) {
			application.setSessionCourante(((ItemMenuSession)item).getSession());
			// MAJ Menus
			refresh(application, item.getId());
			application.declencheMAJMenus();
		} else {
			log.error("Une erreur inattendue est survenue lors de la tentative de changement de session : Il n'y a pas de session en cours");
			application.notifieException(new ExceptionControleur(ExceptionProgrammeExemple.TYPE_CONTROLEUR_MENU,"Une erreur inattendue est survenue"));
		}
			
	}	

	/**
	 *  
	 * Obtient le statut de connexion  la carte
	 * @param application L'application
	 * @param item L'item cliqu
	 * @throws ExceptionProgrammeExemple
	 */
	private static void executeTraitementSpecifiqueEtatConnexionCarte(Application application, ItemMenu item) throws ExceptionProgrammeExemple {	
		
		Resultat resultat = EtatConnexionCarte.traitement(application.getTraitementsSpecifiques());
		// Dclenchement de l'affichage
		if(resultat != null)
			application.declencheAffichageResultat(resultat);
		// MAJ Menus
		if(resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_OK")) {
			refresh(application, item.getId());
		}
			
	}

	/**
	 *  
	 * Invoque l'assistant d'authentification
	 * @param application L'application
	 * @param item L'item cliqu
	 * @throws ExceptionProgrammeExemple
	 */
	private static void executeTraitementSpecifiqueAssistantAuthentification(Application application, ItemMenu item) throws ExceptionProgrammeExemple {	
		
		Resultat resultat = AssistantAuthentification.traitement(application.getTraitementsSpecifiques());

		// Si demande de recyclage
		if(resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_DEMANDE_RECYCLAGE"))
			executeTraitementSpecifiqueRecyclageCodePorteur(application);
		// Dclenchement de l'affichage
		else if(resultat != null) {
			application.declencheAffichageResultat(resultat);
			// MAJ Menus
			if(resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_OK"))
				refresh(application, item.getId());
		}
			
	}	

	/**
	 *  
	 * Invoque l'tat de saisie du code porteur
	 * @param application L'application
	 * @param item L'item cliqu
	 * @throws ExceptionProgrammeExemple
	 */
	private static void executeTraitementSpecifiqueEtatSaisieCodePorteur(Application application, ItemMenu item) throws ExceptionProgrammeExemple {	
		
		Resultat resultat = EtatSaisieCodePorteur.traitement(application.getTraitementsSpecifiques());

		// Si demande de recyclage
		if(resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_DEMANDE_RECYCLAGE"))
			executeTraitementSpecifiqueRecyclageCodePorteur(application);
		// Dclenchement de l'affichage
		else if(resultat != null) {
			application.declencheAffichageResultat(resultat);
		// MAJ Menus
		if(resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_OK"))
			refresh(application, item.getId());
		}
			
	}		

	/**
	 *  
	 * Invoque le recyclage du code porteur
	 * @param application L'application
	 * @param item L'item cliqu
	 * @throws ExceptionProgrammeExemple
	 */
	private static void executeTraitementSpecifiqueRecyclageCodePorteur(Application application) throws ExceptionProgrammeExemple {	
		
		Resultat resultat = RecyclageCodePorteur.traitement(application.getTraitementsSpecifiques());
		// Dclenchement de l'affichage
		if(resultat != null)
			application.declencheAffichageResultat(resultat);
	}		

	/**
	 *  
	 * Invoque l'authentification aprs retrait carte
	 * @param application L'application
	 * @param item L'item cliqu
	 * @throws ExceptionProgrammeExemple
	 */
	private static void executeTraitementSpecifiqueAuthentificationApresRetraitCarte(Application application) throws ExceptionProgrammeExemple {	
		
		Resultat resultat = AuthentificationApresRetraitCarte.traitement(application.getTraitementsSpecifiques());
		
		// Si demande de recyclage
		if(resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_DEMANDE_RECYCLAGE"))
			executeTraitementSpecifiqueRecyclageCodePorteur(application);
		// Dclenchement de l'affichage
		else if(resultat != null) {
			application.declencheAffichageResultat(resultat);
		}
	}
	
	/**
	 *  
	 * Invoque l'authentification aprs retrait lecteur
	 * @param application L'application
	 * @param item L'item cliqu
	 * @throws ExceptionProgrammeExemple
	 */
	private static void executeTraitementSpecifiqueAuthentificationApresRetraitLecteur(Application application) throws ExceptionProgrammeExemple {	
		
		Resultat resultat = AuthentificationApresRetraitLecteur.traitement(application.getTraitementsSpecifiques());
		
		// Si demande de recyclage
		if(resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_DEMANDE_RECYCLAGE"))
			executeTraitementSpecifiqueRecyclageCodePorteur(application);
		// Dclenchement de l'affichage
		else if(resultat != null) {
			application.declencheAffichageResultat(resultat);
		}
	}			
	
	/**
	 *  
	 * Invoque la lecture d'objet de donnes applicatives
	 * @param application L'application
	 * @param item L'item cliqu
	 * @throws ExceptionProgrammeExemple
	 */
	private static void executeTraitementSpecifiqueLectureObjetDonneesApplicatives(Application application) throws ExceptionProgrammeExemple {	
		
		Resultat resultat = LectureObjetDonneesApplicatives.traitement(application.getTraitementsSpecifiques());
		// Dclenchement de l'affichage
		if(resultat != null)
			application.declencheAffichageResultat(resultat);
		// MAJ Menus
//		if(resultat != null && resultat.getCodeRetour() != null && resultat.getCodeRetour().startsWith("CKR_OK")) {
//			refresh(application, item.getId());
//		}
	}

	/**
	 *  
	 * Invoque la modification d'objet de donnes applicatives
	 * @param application L'application
	 * @param item L'item cliqu
	 * @throws ExceptionProgrammeExemple
	 */
	private static void executeTraitementSpecifiqueModificationObjetDonneesApplicatives(Application application) throws ExceptionProgrammeExemple {	
		
		Resultat resultat = ModificationObjetDonneesApplicatives.traitement(application.getTraitementsSpecifiques());
		// Dclenchement de l'affichage
		if(resultat != null)
			application.declencheAffichageResultat(resultat);
		// MAJ Menus
	//	if(resultat != null && resultat.getCodeRetour() != null && resultat.getCodeRetour().startsWith("CKR_OK")) {
	//		refresh(application, item.getId());
	//	}
	}
	
	/**
	 * Effectue les activations/dsactivation ncessaires de menus suite  une opration ralise avec succs
	 * @param application L'application
	 * @param item Item dclencheur
	 */
	public static void refresh(Application application, String item) {
		if(application != null && application.getMenu() != null && application.getMenu().getItemsMenus() != null && application.getFichierProperties() != null) {
			
			
			 Map<Long,String> mapEtatsSession = new HashMap<Long,String>();
			 mapEtatsSession.put(0L,"ropublic");
			 mapEtatsSession.put(1L,"rouser");
			 mapEtatsSession.put(2L,"rwpublic");
			 mapEtatsSession.put(3L,"rwuser");
			 mapEtatsSession.put(4L,"rwso");
			
			application.getMenu().getItemsMenus().keySet();
			for (Iterator<String> iterator = application.getMenu().getItemsMenus().keySet().iterator(); iterator.hasNext();) {

				String id = iterator.next();

				JMenuItem itm = application.getMenu().getItemsMenus().get(id);
				
				////////////////////
				// DESACTIVATIONS //
				////////////////////
				
				if((itm instanceof ItemMenu && ((ItemMenu)itm).isActif()) || (itm instanceof Menu && ((Menu)itm).isActif())) {				
				
					// On desactive les menus qui dpendent des slots que si il n'y a plus de slots
					if(application.getFichierProperties().getProperty(id+".slot.dependant") != null
							&& Boolean.parseBoolean(application.getFichierProperties().getProperty(id+".slot.dependant"))
								&& application.getSlots() != null
									&& application.getSlots().size() == 0)
						application.getMenu().setItemMenuNonActif(id);
					
					// On desactive les menus qui dpendent des cartes que si il n'y a plus de cartes
					else if(application.getFichierProperties().getProperty(id+".carte.dependant") != null
							&& Boolean.parseBoolean(application.getFichierProperties().getProperty(id+".carte.dependant"))
								&& application.getTokens() != null
									&& application.getTokens().size() == 0)
						application.getMenu().setItemMenuNonActif(id);
					
					// On desactive les menus qui dpendent des sessions que si il n'y a plus de sessions
					else if(application.getFichierProperties().getProperty(id+".session.dependant") != null
							&& Boolean.parseBoolean(application.getFichierProperties().getProperty(id+".session.dependant"))
								&& application.nbSessionsActives() == 0)
						application.getMenu().setItemMenuNonActif(id);
					
					
					else if(application.getFichierProperties().getProperty(id+".session.courante.dependant") != null
							&& Boolean.parseBoolean(application.getFichierProperties().getProperty(id+".session.courante.dependant"))) {
						
						if(application.getSessionCourante() == null)
							application.getMenu().setItemMenuNonActif(id);
						
						else {
						
							if(application.getFichierProperties().getProperty(id+".session.courante.dependant") != null
									&& application.getFichierProperties().getProperty(id+".session.type") != null) {
							
								String types = application.getFichierProperties().getProperty(id+".session.type");
								if(types != null) {
									String[] typesTab = types.split("\\|");
									Vector<String> v = new Vector<String>(Arrays.asList(typesTab));
									
									try {
										
										long etatSessionCourante = application.getSessionCourante().getEtatSession();
										if(!v.contains(mapEtatsSession.get(new Long(etatSessionCourante))))
												application.getMenu().setItemMenuNonActif(id);
										
									} catch (ExceptionObjet e) {}
									
								}
							
							}
						}
						
					}					
					
				}
				/////////////////
				// ACTIVATIONS //
				/////////////////
				
				if((itm instanceof ItemMenu && !((ItemMenu)itm).isActif()) || (itm instanceof Menu && !((Menu)itm).isActif())) {
				
					// On active les menus qui dpendent des slots que si il y a au moins un slot
					if(application.getFichierProperties().getProperty(id+".slot.dependant") != null
							&& Boolean.parseBoolean(application.getFichierProperties().getProperty(id+".slot.dependant"))
								&& application.getSlots() != null
									&& application.getSlots().size() > 0)
						application.getMenu().setItemMenuActif(id);
					
					// On active les menus qui dpendent des cartes que si il y a au moins une carte
					else if(application.getFichierProperties().getProperty(id+".carte.dependant") != null
							&& Boolean.parseBoolean(application.getFichierProperties().getProperty(id+".carte.dependant"))
								&& application.getTokens() != null
									&& application.getTokens().size() > 0)
						application.getMenu().setItemMenuActif(id);
					
					// On active les menus qui dpendent des sessions que si il y a au moins une session
					else if(application.getFichierProperties().getProperty(id+".session.dependant") != null
							&& Boolean.parseBoolean(application.getFichierProperties().getProperty(id+".session.dependant"))
									&& application.nbSessionsActives() != 0)
						application.getMenu().setItemMenuActif(id);
	
					// On active les menus qui dpendent de la session que si le type de la session courante l'autorise
					else if(application.getFichierProperties().getProperty(id+".session.courante.dependant") != null
							&& Boolean.parseBoolean(application.getFichierProperties().getProperty(id+".session.courante.dependant"))
								&& application.getSessionCourante() != null) {
						
						if(application.getFichierProperties().getProperty(id+".session.courante.dependant") != null
								&& application.getFichierProperties().getProperty(id+".session.type") != null) {
						
							String types = application.getFichierProperties().getProperty(id+".session.type");
							if(types != null) {
								String[] typesTab = types.split("\\|");
								Vector<String> v = new Vector<String>(Arrays.asList(typesTab));
								
								try {
									
									long etatSessionCourante = application.getSessionCourante().getEtatSession();
									if(v.contains(mapEtatsSession.get(new Long(etatSessionCourante))))
											application.getMenu().setItemMenuActif(id);
									
								} catch (ExceptionObjet e) {}
								
							}
						
						}
						
					}
				}
				
			}
			
			
			// Desactivation de menus spcifiques si necessaire
			String aDesactiver = application.getFichierProperties().getProperty(item+".desactive");
			if(aDesactiver != null) {
				String[] aDesactiverTab = aDesactiver.split("\\|");
				for (int i = 0; i < aDesactiverTab.length; i++) {
						application.getMenu().setItemMenuNonActif(aDesactiverTab[i]);
				}
			}			
			
			// Activation de menus spcifiques si necessaire
			String aActiver = application.getFichierProperties().getProperty(item+".active");
			if(aActiver != null) {
				String[] aActiverTab = aActiver.split("\\|");
				for (int i = 0; i < aActiverTab.length; i++) {
						application.getMenu().setItemMenuActif(aActiverTab[i]);
				}
			}
			
		}
	}

	/**
	 * Dvrouille les menus
	 */
	public static void deverrouille(Application application) {
		
		if(application != null && application.getMenu() != null && application.getMenu().getItemsMenus().values() != null) {

			for (Iterator<JMenuItem> iterator = application.getMenu().getItemsMenus().values().iterator(); iterator.hasNext();) {
				JMenuItem menu = (JMenuItem) iterator.next();
				menu.setEnabled(true);
			}
			
		}
	}
	
	/**
	 * Vrouille les menus
	 */
	public static void verrouille(Application application) {
		
		if(application != null && application.getMenu() != null && application.getMenu().getItemsMenus().values() != null) {

			for (Iterator<JMenuItem> iterator = application.getMenu().getItemsMenus().values().iterator(); iterator.hasNext();) {
				JMenuItem menu = (JMenuItem) iterator.next();
				
				if(menu instanceof ItemMenu) {
					menu.setEnabled(((ItemMenu)menu).isActif());
				}
				else if(menu instanceof Menu) {
					menu.setEnabled(((Menu)menu).isActif());		
				}
			}			
		}
	}	
	
	/**
	 * Mise  jour des Menus slots
	 * @param application L'application
	 */
	public static void majMenusSlots(Application application) {
		
		if(application != null && application.getMenu() != null && application.getSlots() != null) {
		
			Vector<Slot> slots = application.getSlots();
			
			// suppression des tous les items de menu slots
			application.getMenu().supprimeContenuMenu(MenuApplication.P11_SLOTSCARTES_INFOSLOT);
	
			if(slots != null && slots.size() != 0) {
				// ajout de tous les menus slots
				for (int i = 0; i < slots.size(); i++) {
					Slot slot = slots.get(i);
					if(slot != null && application.getItemMenu(MenuApplication.P11_GENERAL_INITLIB) != null) {
						ActionListener ecouteur = application.getItemMenu(MenuApplication.P11_GENERAL_INITLIB).getActionEcouteur();
						application.getMenu().ajouteItemMenu(new ItemMenuSlot(slot,MenuApplication.P11_SLOTSCARTES_INFOSLOT,true,true,ecouteur));
					}
				}
			}
		}
	}	

	/**
	 * Mise  jour des Menus tokens
	 * @param application L'application
	 */
	public static void majMenusTokens(Application application) {
		
		try {
		
			if(application != null && application.getMenu() != null && application.getTokens() != null) {
			
				Vector<Token> tokens = application.getTokens();
				
				// suppression des tous les items de menu tokens
				application.getMenu().supprimeContenuMenu(MenuApplication.P11_SLOTSCARTES_INFOCARTE);
				application.getMenu().supprimeContenuMenu(MenuApplication.P11_SLOTSCARTES_LISTERALGOCARTE);
				application.getMenu().supprimeContenuMenu(MenuApplication.P11_SLOTSCARTES_INFOALGO);
//				application.getMenu().supprimeContenuMenu(MenuApplication.P11_SLOTSCARTES_INITPIN);
//				application.getMenu().supprimeContenuMenu(MenuApplication.P11_SLOTSCARTES_MODIFPIN);
				application.getMenu().supprimeContenuMenu(MenuApplication.P11_SESSIONS_OUVRIR_LECTSEULE);
				application.getMenu().supprimeContenuMenu(MenuApplication.P11_SESSIONS_OUVRIR_LECTECRIT);
				application.getMenu().supprimeContenuMenu(MenuApplication.P11_SESSIONS_FERMER_TOUTES);
				application.getMenu().supprimeContenuMenu(MenuApplication.P11_EMPREINTES_MESSAGE);
				application.getMenu().supprimeContenuMenu(MenuApplication.P11_EMPREINTES_FICHIER);
				application.getMenu().supprimeContenuMenu(MenuApplication.P11_SIGNATURES_MESSAGE);
				application.getMenu().supprimeContenuMenu(MenuApplication.P11_SIGNATURES_FICHIER);
				application.getMenu().supprimeContenuMenu(MenuApplication.P11_VERIFICATIONS_MESSAGE);
				application.getMenu().supprimeContenuMenu(MenuApplication.P11_VERIFICATIONS_FICHIER);
		
				if(tokens.size() != 0) {
					// ajout de tous les menus tokens et algos
					for (int i = 0; i < tokens.size(); i++) {
						Token token = tokens.get(i);
						if(token != null && application.getItemMenu(MenuApplication.P11_GENERAL_INITLIB) != null) {
							ActionListener ecouteur = application.getItemMenu(MenuApplication.P11_GENERAL_INITLIB).getActionEcouteur();
							
							// MAJ Menu tokens
							application.getMenu().ajouteItemMenu(new ItemMenuToken(token,MenuApplication.P11_SLOTSCARTES_INFOCARTE,true,true,ecouteur));
							application.getMenu().ajouteItemMenu(new ItemMenuToken(token,MenuApplication.P11_SLOTSCARTES_LISTERALGOCARTE,true,true,ecouteur));
//							application.getMenu().ajouteItemMenu(new ItemMenuToken(token,MenuApplication.P11_SLOTSCARTES_INITPIN,true,true,ecouteur));
//							application.getMenu().ajouteItemMenu(new ItemMenuToken(token,MenuApplication.P11_SLOTSCARTES_MODIFPIN,true,true,ecouteur));
							application.getMenu().ajouteMenu(new MenuToken(token,MenuApplication.P11_SLOTSCARTES_INFOALGO,true,true));
							application.getMenu().ajouteItemMenu(new ItemMenuToken(token,MenuApplication.P11_SESSIONS_OUVRIR_LECTSEULE,true,true,ecouteur));
							application.getMenu().ajouteItemMenu(new ItemMenuToken(token,MenuApplication.P11_SESSIONS_OUVRIR_LECTECRIT,true,true,ecouteur));
							application.getMenu().ajouteItemMenu(new ItemMenuToken(token,MenuApplication.P11_SESSIONS_FERMER_TOUTES,true,true,ecouteur));
							
							// MAJ Menu algos et objets
							majMenusAlgo(application,token);
							
							// MAJ du Menu objet uniquement pour le token li  la session courante
							if(application.getSessionCourante() != null	&& application.getSessionCourante().getIdSlot() == token.getIdSlotToken())
								majMenusObjets(application,token);
	
						}
					}
				}
			}
		}  catch (ExceptionObjet e) {
			
			// Demande d'affichage de l'exception
			application.notifieException(e);
			
		}
	}
	
	/**
	 * Mise  jour des Menus algos
	 * @param application L'application
	 * @token token Token porteur de l'algo
	 */
	public static void majMenusAlgo(Application application,Token token) {
		
		try {

			if(application != null && token != null && application.getMenu() != null && application.getAlgo() != null && application.getAlgo().get(token.getNumeroSerie()) != null) {
			
				Vector<Algo> algos = application.getAlgo().get(token.getNumeroSerie());
				
				// suppression des tous les items de menu algo
				application.getMenu().supprimeContenuMenu(MenuApplication.P11_SLOTSCARTES_INFOALGO+","+Long.toString(token.getIdSlotToken()));
		
				if(algos.size() != 0) {
					
					application.getMenu().setItemMenuActif(MenuApplication.P11_SLOTSCARTES_INFOALGO+","+Long.toString(token.getIdSlotToken()));
					
					// ajout de tous les menus tokens
					for (int i = 0; i < algos.size(); i++) {
						Algo algo = algos.get(i);
						if(algo != null && application.getItemMenu(MenuApplication.P11_GENERAL_INITLIB) != null) {
							ActionListener ecouteur = application.getItemMenu(MenuApplication.P11_GENERAL_INITLIB).getActionEcouteur();
							application.getMenu().ajouteItemMenu(new ItemMenuAlgo(algo,MenuApplication.P11_SLOTSCARTES_INFOALGO+","+Long.toString(token.getIdSlotToken()),true,true,ecouteur));
							// on ajoute les algos du token de la session courante, dans les menus empreinte/signature
							if(application.getSessionCourante() != null && token.getNumeroSerie() != null && token.getNumeroSerie().equalsIgnoreCase(application.getSessionCourante().getIdToken())) {
								
								// Ajout des algorithmes de hashing
								if(algo.isRealiseCondensat()) {
									
									application.getMenu().ajouteItemMenu(new ItemMenuAlgo(algo,MenuApplication.P11_EMPREINTES_MESSAGE,true,true,ecouteur));
									application.getMenu().ajouteItemMenu(new ItemMenuAlgo(algo,MenuApplication.P11_EMPREINTES_FICHIER,true,true,ecouteur));
									
								}
								
								// Ajout des algorithmes de signature
								if(algo.isRealiseSignature()) {
									
									application.getMenu().ajouteMenu(new MenuAlgo(algo,MenuApplication.P11_SIGNATURES_MESSAGE,false,true));
									application.getMenu().ajouteMenu(new MenuAlgo(algo,MenuApplication.P11_SIGNATURES_FICHIER,false,true));
									
									application.getMenu().supprimeContenuMenu(MenuApplication.P11_SIGNATURES_MESSAGE+","+Long.toString(algo.getIdAlgo()));
									application.getMenu().supprimeContenuMenu(MenuApplication.P11_SIGNATURES_FICHIER+","+Long.toString(algo.getIdAlgo()));
								}
								
								// Ajout des algorithmes de vrifications de signature
								if(algo.isVerificationSignature()) {
									
									application.getMenu().ajouteMenu(new MenuAlgo(algo,MenuApplication.P11_VERIFICATIONS_MESSAGE,false,true));
									application.getMenu().ajouteMenu(new MenuAlgo(algo,MenuApplication.P11_VERIFICATIONS_FICHIER,false,true));
									
									application.getMenu().supprimeContenuMenu(MenuApplication.P11_VERIFICATIONS_MESSAGE+","+Long.toString(algo.getIdAlgo()));
									application.getMenu().supprimeContenuMenu(MenuApplication.P11_VERIFICATIONS_FICHIER+","+Long.toString(algo.getIdAlgo()));	
	
								}
								
								// Ajout des cls pour les algorithme de signature et de vrification de signature
								if(algo.isRealiseSignature() || algo.isVerificationSignature()) {
									majMenusCles(application, algo, token.getNumeroSerie());
								}
							}
						}
					}
				}
			}
		} catch (ExceptionObjet e) {
			
			// Demande d'affichage de l'exception
			application.notifieException(e);
			
		}
	}
	
	/**
	 * Mise  jour des Menus cls
	 * @param application L'application
	 */
	public static void majMenusCles(Application application, Algo algo, String idToken) {

		try {
		
			if(application != null && algo != null && application.getMenu() != null && application.getClesPrivees() != null) {
			
				Vector<Cle> clesPrivees = application.getClesPrivees().get(idToken);
				Vector<Cle> clesPubliques = application.getClesPubliques().get(idToken);
		
				if(clesPrivees != null && clesPrivees.size() != 0) {			
	
					if(algo.isRealiseSignature()) {
						application.getMenu().setItemMenuActif(MenuApplication.P11_SIGNATURES_MESSAGE+","+Long.toString(algo.getIdAlgo()));
						application.getMenu().setItemMenuActif(MenuApplication.P11_SIGNATURES_FICHIER+","+Long.toString(algo.getIdAlgo()));
						application.getMenu().setItemMenuActif(MenuApplication.P11_SIGNATURES_MESSAGE+","+Long.toString(algo.getIdAlgo()));
						application.getMenu().setItemMenuActif(MenuApplication.P11_SIGNATURES_FICHIER+","+Long.toString(algo.getIdAlgo()));
					}
	
					// ajout de tous les menus cle
					for (int i = 0; i < clesPrivees.size(); i++) {
						Cle cle = clesPrivees.get(i);
						if(cle != null && application.getItemMenu(MenuApplication.P11_GENERAL_INITLIB) != null) {
							ActionListener ecouteur = application.getItemMenu(MenuApplication.P11_GENERAL_INITLIB).getActionEcouteur();
	
							// on ajoute les cle du token de la session courante, dans les menus signatures
							if(application.getSessionCourante() != null && idToken != null && idToken.equalsIgnoreCase(application.getSessionCourante().getIdToken())) {
								
								if(algo.isRealiseSignature()) {
									application.getMenu().ajouteItemMenu(new ItemMenuCle(cle,MenuApplication.P11_SIGNATURES_MESSAGE+","+Long.toString(algo.getIdAlgo()),true,true,ecouteur));
									application.getMenu().ajouteItemMenu(new ItemMenuCle(cle,MenuApplication.P11_SIGNATURES_FICHIER+","+Long.toString(algo.getIdAlgo()),true,true,ecouteur));
								}	
								
							}
						}
					}
	
				}
	
				if(clesPubliques != null && clesPubliques.size() != 0) {			
				
					if(algo.isVerificationSignature()) {
						application.getMenu().setItemMenuActif(MenuApplication.P11_VERIFICATIONS_MESSAGE+","+Long.toString(algo.getIdAlgo()));
						application.getMenu().setItemMenuActif(MenuApplication.P11_VERIFICATIONS_FICHIER+","+Long.toString(algo.getIdAlgo()));
						application.getMenu().setItemMenuActif(MenuApplication.P11_VERIFICATIONS_MESSAGE+","+Long.toString(algo.getIdAlgo()));
						application.getMenu().setItemMenuActif(MenuApplication.P11_VERIFICATIONS_FICHIER+","+Long.toString(algo.getIdAlgo()));
					}
					
					// ajout de tous les menus cle
					for (int i = 0; i < clesPubliques.size(); i++) {
						Cle cle = clesPubliques.get(i);
						if(cle != null && application.getItemMenu(MenuApplication.P11_GENERAL_INITLIB) != null) {
							ActionListener ecouteur = application.getItemMenu(MenuApplication.P11_GENERAL_INITLIB).getActionEcouteur();
	
							// on ajoute les cle du token de la session courante, dans les menus signatures
							if(application.getSessionCourante() != null && idToken != null && idToken.equalsIgnoreCase(application.getSessionCourante().getIdToken())) {
								
								if(algo.isVerificationSignature()) {
									application.getMenu().ajouteItemMenu(new ItemMenuCle(cle,MenuApplication.P11_VERIFICATIONS_MESSAGE+","+Long.toString(algo.getIdAlgo()),true,true,ecouteur));
									application.getMenu().ajouteItemMenu(new ItemMenuCle(cle,MenuApplication.P11_VERIFICATIONS_FICHIER+","+Long.toString(algo.getIdAlgo()),true,true,ecouteur));
								}		
								
							}
						}
					}
				}
			}
		}  catch (ExceptionObjet e) {
			
			// Demande d'affichage de l'exception
			application.notifieException(e);
			
		}
	}
	
	/**
	 * Mise  jour des Menus sessions
	 * @param application L'application
	 */
	public static void majMenusSessions(Application application) {
		
		if(application != null && application.getMenu() != null && application.getSessions() != null) {
		
			TreeMap<String, Vector<Session>> sessions = application.getSessions();
			
			// suppression des tous les items de menu session
			application.getMenu().supprimeContenuMenu(MenuApplication.SESSIONS);
			application.getMenu().supprimeContenuMenu(MenuApplication.P11_SESSIONS_FERMER);
	
			// ajout de tous les menus sessions
			if(sessions != null && application.getItemMenu(MenuApplication.P11_GENERAL_INITLIB) != null) {
				ActionListener ecouteur = application.getItemMenu(MenuApplication.P11_GENERAL_INITLIB).getActionEcouteur();
				for (Iterator<String> iterator = sessions.keySet().iterator(); iterator.hasNext();) {
					String token = iterator.next();
					if(token != null) {
						Vector<Session> sessionsToken = sessions.get(token);
						Vector<Session> sessionsInvalides = new Vector<Session>();
						if(sessionsToken != null) {
							for (Iterator<Session> iterator2 = sessionsToken.iterator(); iterator2.hasNext();) {
								Session session = (Session) iterator2.next();
								boolean ajouteSession = true;
								
								try {
									
									// on recherche les informations de la session
									session.chargeInfo(application.getLibrairieP11());
									
								} catch (ExceptionObjet e) {

									/* Si la session est obsolte on prpare nettoyage */
									if(e.getCause() != null && e.getCause() instanceof PKCS11Exception) {
										
										if("0x000000B3".equalsIgnoreCase("0x" + Functions.toFullHexString((int)((PKCS11Exception)e.getCause()).getErrorCode()))) {
											sessionsInvalides.add(session);
											ajouteSession = false;
										}
										
									} else {
									
										// Demande d'affichage de l'exception
										application.notifieException(e);
										
									}
									
								}
								if(ajouteSession) {
									if(application.getSessionCourante() == session) {
										application.getMenu().ajouteItemMenu(new ItemMenuSession(session,MenuApplication.SESSIONS,true,true,true,ecouteur));
										application.getMenu().ajouteItemMenu(new ItemMenuSession(session,MenuApplication.P11_SESSIONS_FERMER,true,true,true,ecouteur));					
									} else {
										application.getMenu().ajouteItemMenu(new ItemMenuSession(session,MenuApplication.SESSIONS,false,true,true,ecouteur));
										application.getMenu().ajouteItemMenu(new ItemMenuSession(session,MenuApplication.P11_SESSIONS_FERMER,false,true,true,ecouteur));
									}
								}
							}
						}
						
						/* Nettoyage des sessions obsoltes */
						for (Iterator<Session> iterator2 = sessionsInvalides.iterator(); iterator2
								.hasNext();) {
							Session session = iterator2.next();
							application.supprimeLaSession(session.getIdToken(), session);
							
						}
					}
				}
			}
		}
	}

	/**
	 * Mise  jour des Menus objet
	 * @param application L'application
	 * @token token Token porteur de l'objet
	 */
	public static void majMenusObjets(Application application,Token token) {

		try {
		
			if(application != null && token != null 
					&& application.getMenu() != null 
							&& application.getObjets() != null 
								&& application.getObjets().get(token.getNumeroSerie()) != null) {
			
				Vector<Objet> objets = application.getObjets().get(token.getNumeroSerie());
				
				// suppression des tous les items de menu objets
				application.getMenu().supprimeContenuMenu(MenuApplication.P11_OBJETS_GESTION_AFFICHEATTRIBUT_SURCARTE);
				application.getMenu().supprimeContenuMenu(MenuApplication.P11_OBJETS_GESTION_MODIFATTRIBUT_SURCARTE);
				application.getMenu().supprimeContenuMenu(MenuApplication.P11_OBJETS_GESTION_COPIER_SURCARTE);
				application.getMenu().supprimeContenuMenu(MenuApplication.P11_OBJETS_GESTION_TAILLE_SURCARTE);
				application.getMenu().supprimeContenuMenu(MenuApplication.P11_OBJETS_GESTION_SUPPR_SURCARTE);
				
				// Afin de gris les menus si il n'y a pas/plus d'objets
//				application.getMenu().setItemMenuNonActif(MenuApplication.P11_OBJETS_GESTION_AFFICHEATTRIBUT);
//				application.getMenu().setItemMenuNonActif(MenuApplication.P11_OBJETS_GESTION_MODIFATTRIBUT);
//				application.getMenu().setItemMenuNonActif(MenuApplication.P11_OBJETS_GESTION_COPIER);
//				application.getMenu().setItemMenuNonActif(MenuApplication.P11_OBJETS_GESTION_TAILLE);
//				application.getMenu().setItemMenuNonActif(MenuApplication.P11_OBJETS_GESTION_SUPPR);
//				application.getMenu().setItemMenuNonActif(MenuApplication.P11_OBJETS_GESTION_AFFICHEATTRIBUT_SURCARTE);
//				application.getMenu().setItemMenuNonActif(MenuApplication.P11_OBJETS_GESTION_MODIFATTRIBUT_SURCARTE);
//				application.getMenu().setItemMenuNonActif(MenuApplication.P11_OBJETS_GESTION_COPIER_SURCARTE);
//				application.getMenu().setItemMenuNonActif(MenuApplication.P11_OBJETS_GESTION_TAILLE_SURCARTE);
//				application.getMenu().setItemMenuNonActif(MenuApplication.P11_OBJETS_GESTION_SUPPR_SURCARTE);
		
				if(objets.size() != 0) {
	
//					application.getMenu().setItemMenuActif(MenuApplication.P11_OBJETS_GESTION_AFFICHEATTRIBUT);
//					application.getMenu().setItemMenuActif(MenuApplication.P11_OBJETS_GESTION_MODIFATTRIBUT);
//					application.getMenu().setItemMenuActif(MenuApplication.P11_OBJETS_GESTION_COPIER);
//					application.getMenu().setItemMenuActif(MenuApplication.P11_OBJETS_GESTION_TAILLE);
//					application.getMenu().setItemMenuActif(MenuApplication.P11_OBJETS_GESTION_SUPPR);
//					application.getMenu().setItemMenuActif(MenuApplication.P11_OBJETS_GESTION_AFFICHEATTRIBUT_SURCARTE);
//					application.getMenu().setItemMenuActif(MenuApplication.P11_OBJETS_GESTION_MODIFATTRIBUT_SURCARTE);
//					application.getMenu().setItemMenuActif(MenuApplication.P11_OBJETS_GESTION_COPIER_SURCARTE);
//					application.getMenu().setItemMenuActif(MenuApplication.P11_OBJETS_GESTION_TAILLE_SURCARTE);
//					application.getMenu().setItemMenuActif(MenuApplication.P11_OBJETS_GESTION_SUPPR_SURCARTE);
					
					// ajout de tous les menus tokens
					for (int i = 0; i < objets.size(); i++) {
						Objet objet = objets.get(i);
						if(objet != null && application.getItemMenu(MenuApplication.P11_GENERAL_INITLIB) != null) {
							ActionListener ecouteur = application.getItemMenu(MenuApplication.P11_GENERAL_INITLIB).getActionEcouteur();
							
							// on ajoute les objets du token de la session courante, dans les menus appropris
							if(application.getSessionCourante() != null && token.getNumeroSerie() != null && token.getNumeroSerie().equalsIgnoreCase(application.getSessionCourante().getIdToken())) {
								
								// Ajout des objets
								application.getMenu().ajouteItemMenu(new ItemMenuObjet(objet,MenuApplication.P11_OBJETS_GESTION_AFFICHEATTRIBUT_SURCARTE,true,true,ecouteur));
								application.getMenu().ajouteItemMenu(new ItemMenuObjet(objet,MenuApplication.P11_OBJETS_GESTION_MODIFATTRIBUT_SURCARTE,true,true,ecouteur));
								application.getMenu().ajouteItemMenu(new ItemMenuObjet(objet,MenuApplication.P11_OBJETS_GESTION_COPIER_SURCARTE,true,true,ecouteur));
								application.getMenu().ajouteItemMenu(new ItemMenuObjet(objet,MenuApplication.P11_OBJETS_GESTION_TAILLE_SURCARTE,true,true,ecouteur));
								application.getMenu().ajouteItemMenu(new ItemMenuObjet(objet,MenuApplication.P11_OBJETS_GESTION_SUPPR_SURCARTE,true,true,ecouteur));
								
							}
						}
					}
				}
			}
		}  catch (ExceptionObjet e) {
			
			// Demande d'affichage de l'exception
			application.notifieException(e);
			
		}
	}
	
	/**
	 * Mise  jour de tous les menus
	 * @param application L'application
	 */
	public static void majMenus(Application application) {
		majMenusSlots(application);
		majMenusTokens(application); // met egalement  jour les menus algo objets et cls
		majMenusSessions(application);
	}
}
